#!/bin/bash
#
usage() {
    echo "$(basename ${0}) [-h|--help] [-t|--token-file=<file>] [-g|--gitlab-url=<url>] ID"
    echo "Get project name from Gitlab by id"
    echo "	--help | -h                      Print this help"
    echo "	--token-file= | -t <file>        Set file with Gitlab token"
    echo "	--gitlab-url=* | -g <url>        Set Gtilab URL"
    exit 1
}

# Map long options to short ones and rebuild argv
declare GITLAB_URL="https://git.mws-team.ru"
declare TOKEN_FILE=""
declare ID=""

translated=()
while (( $# )); do
    case "$1" in
        --help)          translated+=("-h"); shift ;;
        --token-file=*)  translated+=("-t" "${1#*=}"); shift ;;
        --gitlab-url=*)  translated+=("-g" "${1#*=}"); shift ;;
        --)              translated+=("--"); shift; translated+=("$@"); set -- ;;
        *)               translated+=("$1"); shift ;;
      esac
done
set -- "${translated[@]}"

while getopts ":ht:g:" opt; do
    case "$opt" in
        h) usage ;;
        t) TOKEN_FILE=$OPTARG ;;
        g) GITLAB_URL=$OPTARG ;;
        :) echo "Missing arg for -$OPTARG"; usage ;;
        \?) echo "Invalid option: -$OPTARG"; usage ;;
    esac
done

shift $((OPTIND - 1))
if [[ -n "$@" ]]
then
	ID=$@
fi

function checks {
    if [ -z "${TOKEN_FILE}" ]
    then
        echo "Missing token file"
        usage
    fi
    
    if [ -z "${GITLAB_URL}" ]
    then
        echo "Missing gitlab url"
        usage
    fi
    
    if [ ! -f "${TOKEN_FILE}" ]
    then
        echo "Token file not found"
        usage
    fi

    re='^[0-9]+$'
    if ! [[ ${ID} =~ ${re} ]]
    then
	    echo "${ID}"
	    echo "ID is not number"
	    usage
    fi
}

curl --silent --header "PRIVATE-TOKEN: $(cat ${TOKEN_FILE})" "${GITLAB_URL}/api/v4/projects/${ID}" | jq '. | {name: .name, name_with_namespace: .name_with_namespace, path_with_namespace: .path_with_namespace}'

